var Thanks_Obj;

// Setup the main object
Thanks_Obj = function()
{
	// Which blocks correspond to which thingy
	this.postid = 0;
	
	// The AJAX request
	this.xhr = false;
	
	// #########################################################################
	// Initialise the Info Panels
	this.init = function(postid)
	{
		this.postid = postid;
		
		if (!AJAX_Compatible)
		{
			// AJAX won't work, this is foar srs.
			YAHOO.util.Dom.get('dbtech_thanks_status_' + this.postid).innerHTML = 'Either your browser does not support AJAX, or the forum administrator has chosen to disable AJAX. Advanced Post Thanks / Like cannot run under these conditions.';
			// REPLACESTRING
			
			return false;
		}
	};
	
	
	
	// #########################################################################
	// Shorthand for an ajax call
	this.ajax_call = function(varname, extraparams)
	{
		if (this.xhr != false)
		{
			// We're already doing things
			return false;
		}
		
		this.xhr = YAHOO.util.Connect.asyncRequest('POST', 'thanks.php', {
			success: this.ajax_completed,
			failure: this.handle_ajax_error,
			timeout: vB_Default_Timeout,
			scope: this
		}, SESSIONURL + 'securitytoken=' + SECURITYTOKEN + '&do=ajax&action=entry&varname=' + varname + '&postid=' + this.postid + extraparams);
		
		return false;
	};

	// #########################################################################
	// Finalise fetching of content
	this.ajax_completed = function(ajax)
	{
		// Let's allow another AJAX request
		this.xhr = false;
		
		if (!ajax.responseXML)
		{
			// Empty response
			YAHOO.util.Dom.get('dbtech_thanks_status_' + this.postid).innerHTML = 'Invalid response from server: ' + ajax.responseText;
			return false;
		}
		
		// check for error first
		var error = ajax.responseXML.getElementsByTagName('error');
			
		if (error.length)
		{
			// Throw the error returned
			YAHOO.util.Dom.get('dbtech_thanks_status_' + this.postid).innerHTML = error[0].firstChild.nodeValue;
			return false;
		}
		
		// Reset status
		YAHOO.util.Dom.get('dbtech_thanks_status_' + this.postid).innerHTML = '';
		
		var tags = [
			'actions', 'entries'
		];
		for (var t = 0; t < tags.length; t++)
		{
			eval('var ' + tags[t] + ' = ajax.responseXML.getElementsByTagName("' + tags[t] + '");');
		}
		
		if (actions.length)
		{
			// Parse block 1
			YAHOO.util.Dom.get('dbtech_thanks_actions_' + this.postid).innerHTML = (actions[0].firstChild ? actions[0].firstChild.nodeValue : '');
		}
		
		if (entries.length)
		{
			// Parse block 1
			YAHOO.util.Dom.get('dbtech_thanks_entries_' + this.postid).innerHTML = (entries[0].firstChild ? entries[0].firstChild.nodeValue : '');
		}
		
		// Refresh the post
		this.display_post(this.postid);
	};
	
	// #########################################################################
	// This should never happen.
	this.handle_ajax_error = function(ajax)
	{
		// Let's allow another AJAX request
		this.xhr = false;

		if (ajax.statusText == 'transaction aborted' || ajax.statusText == 'communication failure')
		{
			// Try again!
			return false;
		}
		
		if (YAHOO.util.Dom.get('dbtech_thanks_status_' + this.postid))
		{
			YAHOO.util.Dom.get('dbtech_thanks_status_' + this.postid).innerHTML = ajax.statusText;
			
			// Log the error to the console
			console.error(this.timestamp() + "AJAX Error: Status = %s: %s", ajax.status, ajax.statusText);
		}
		else
		{
			// Just pop it up
			alert(ajax.statusText);
		}
	};
	
	
	// #########################################################################
	// Debugging function, generates a timestamp of when something occurred
	this.timestamp = function()
	{
		var d = new Date();
		
		return '[' + d.getHours() + ':' + d.getMinutes() + ':' + d.getSeconds() + '] ';
	};	
	
	// #########################################################################
	// Refreshes a post display
	this.display_post = function(postid)
	{
		if (AJAX_Compatible)
		{
			Thanks_PostLoader[postid] = new Thanks_AJAX_PostLoader(postid);
			Thanks_PostLoader[postid].init();
		}
		else
		{
			pc_obj = fetch_object('postcount' + postid);
			openWindow('showthread.php?' + (SESSIONURL ? 's=' + SESSIONURL : '') + (pc_obj != null ? '&postcount=' + PHP.urlencode(pc_obj.name) : '') + '&p=' + postid + "#post" + postid);
		}
		return false;
	};	
};

// #############################################################################
// Thanks_AJAX_PostLoader
// #############################################################################

var Thanks_PostLoader = new Array();

/**
* Class to load a postbit via AJAX
*
* @package	vBulletin
* @version	$Revision: 35508 $
* @date		$Date: 2010-02-23 07:07:31 -0800 (Tue, 23 Feb 2010) $
* @author	Kier Darby, vBulletin Development Team
*
* @param	integer	Post ID
*/
function Thanks_AJAX_PostLoader(postid)
{
	this.postid = postid;
	this.post = YAHOO.util.Dom.get('post_' + this.postid);
};

/**
* Initiates the AJAX send to showpost.php
*/
Thanks_AJAX_PostLoader.prototype.init = function()
{
	if (this.post)
	{
		postid = this.postid;
		pc_obj = fetch_object('postcount' + this.postid);

		YAHOO.util.Connect.asyncRequest("POST", "showpost.php?p=" + this.postid, {
			success: this.display,
			failure: this.handle_ajax_error,
			timeout: vB_Default_Timeout,
			scope: this
		}, SESSIONURL + "securitytoken=" + SECURITYTOKEN + "&ajax=1&postid=" + this.postid + (pc_obj != null ? "&postcount=" + PHP.urlencode(pc_obj.name) : ""));
	}
};

/**
* Handles AJAX Errors
*
* @param	object	YUI AJAX
*/
Thanks_AJAX_PostLoader.prototype.handle_ajax_error = function(ajax)
{
	//TODO: Something bad happened, try again
	vBulletin_AJAX_Error_Handler(ajax);
};

/**
* Takes the AJAX HTML output and replaces the existing post placeholder with the new HTML
*
* @param	object	YUI AJAX
*/
Thanks_AJAX_PostLoader.prototype.display = function(ajax)
{
	if (ajax.responseXML)
	{
		var postbit = ajax.responseXML.getElementsByTagName("postbit");

		if (postbit.length)
		{
			var newpostbit = string_to_node(postbit[0].firstChild.nodeValue);
			this.post.parentNode.replaceChild(newpostbit, this.post);

			//this.container.innerHTML = postbit[0].firstChild.nodeValue;
			PostBit_Init(newpostbit, this.postid);
		}
		else
		{	// parsing of XML failed, probably IE
			openWindow('showthread.php?' + (SESSIONURL ? 's=' + SESSIONURL : '') + (pc_obj != null ? '&postcount=' + PHP.urlencode(pc_obj.name) : '') + '&p=' + this.postid + "#post" + this.postid);
		}
	}
};